
import argparse, os, json
from src.present_act.gates import ThetaLadder, KappaLadder, StructuralGates, CRA
from src.present_act.lints import Lints
from src.present_act.engine import PresentActEngine, RunManifest
from src.present_act.scenes import make_optics_scene, make_optics_roi, place_sources_from_s, make_central_corridor_mask
from scripts._util import ensure_out, write_md, load_cfg

def rng_only_at_ties():
    scene = make_optics_scene(128, w=5)
    scene.allowed_mask = make_central_corridor_mask(scene, halfwidth=0)
    screen = make_optics_roi(scene)
    (xL,y_s),(xR,y_s2) = place_sources_from_s(scene, s=40, y_row=scene.H//4)
    theta = ThetaLadder([3,4,5]); kappa = KappaLadder([0,1,2])
    man = RunManifest(theta,kappa,StructuralGates(),CRA(True),Lints(),seed=101)
    eng = PresentActEngine(scene, man)
    cands = eng.propose_candidates([ (xL,y_s), (xR,y_s2) ], screen)
    _, res1 = eng.accept(cands)
    cands2 = eng.propose_candidates([ (xL+1,y_s), (xR,y_s2) ], screen)
    _, res2 = eng.accept(cands2)
    return {"tie_rng": bool(res1.rng_used and res1.tie_count>1), "no_rng_after_break": bool(not res2.rng_used)}

def no_skip_guard():
    ok=False
    try:
        Lints().assert_no_skip(2)
    except AssertionError:
        ok=True
    return {"no_skip_enforced": ok}

def main(cfg):
    outd = ensure_out("out")
    r1 = rng_only_at_ties()
    r2 = no_skip_guard()
    passed = r1["tie_rng"] and r1["no_rng_after_break"] and r2["no_skip_enforced"]
    write_md(os.path.join(outd,"PREPASS.md"), f"# Preflight\n{r1}\n{r2}\nPASSED={passed}\n")
    print("Preflight:", "PASSED" if passed else "FAILED")

if __name__ == "__main__":
    ap = argparse.ArgumentParser()
    ap.add_argument("--config", default="configs/low_compute.yaml")
    args = ap.parse_args()
    cfg = load_cfg(args.config)
    main(cfg)
